$(document).ready(function(){

    $(".btn-detalle-pedido").on('click', function(e){
        e.preventDefault();

        var id_pedido = $(this).data('id');
        var path = $(this).data('path');
        var token = $(this).data('token');
        var modal_title = $(".modal-title");
        var modal_body = $(".modal-body");
        var loading = '<p><i class="fa fa-circle-o-notch fa-spin"></i> Cargando datos</p>';
        var table = $("#table-detalle-pedido tbody");
        var data = {'_token' : token, 'order_id' : id_pedido};

        modal_title.html('Detalle del Pedido: ' + id_pedido);
        table.html(loading);

        $.post(
            path,
            data,
            function(data){
                //console.log(response);
                table.html("");
                
                for(var i=0; i<data.length; i++){
                    
                    var fila = "<tr>";
                    
                    fila += "<td>" + data[i].product.name + "</td>";
                    fila += "<td>$ " + parseFloat(data[i].price).toFixed(2) + "</td>";
                    fila += "<td>" + parseInt(data[i].quantity) + "</td>";
                    fila += "<td>" + parseInt(data[i].discount) + "%</td>";
                    fila += "<td>$ " + (parseFloat(data[i].quantity) * parseFloat(data[i].price)*((100 - parseFloat(data[i].discount))/100)).toFixed(2) + "</td>";
                    fila += "</tr>";
                    
                    table.append(fila);
                }
            },
            'json'
        );

    });

    $(".btn-servirent").click(function(e){
        e.preventDefault();
        var id = $(this).data('id');
        var url = $(this).data('url');
        var orderid= $(this).data('orderid');
        var area= $(this).data('area');
        var cantidad= $(this).data('cantidad');
        var name= $(this).data('name');
        var username= $(this).data('username');
        var origen= $(this).data('origen');
                
        window.location.href = url + "/servirent/" + id + "/" + orderid + "/" + area + "/" + cantidad + "/" + name + "/" + username + "/" + origen
    }); 

    

    $(".btn-entregar").click(function(e){
        e.preventDefault();
        var id = $(this).data('id');
        var url = $(this).data('url');
        var orderid= $(this).data('orderid');
        var estado= $(this).data('estado');
        var category= $(this).data('category');
        
        if((estado == 'Servido') || (category == '4')){
            window.location.href = url + "/entregar/" + id + "/" + orderid
        }        
        
    });

    $(".btn-agregar").click(function(e){
        e.preventDefault();
        var id = $(this).data('id');
        var area = $(this).data('area');
                        
        window.location.href = url + "/cart/add/" + id + "/" + area
    }); 

}); 