importScripts(
	'https://storage.googleapis.com/workbox-cdn/releases/4.3.1/workbox-sw.js'
);


// js/css files
workbox.routing.registerRoute(
        /\.(?:js|css)$/,
        new workbox.strategies.CacheFirst({cacheName: 'static'})
    );

// images
    workbox.routing.registerRoute(
        // Cache image files.
        /\.(?:png|jpg|jpeg|svg|gif|ico)$/,
        // Use the cache if it's available.
        new workbox.strategies.CacheFirst({cacheName: 'static'})
    );

// Cache the underlying font files with a cache-first strategy for 1 year.
workbox.routing.registerRoute(
  ({url}) => url.origin === 'https://fonts.gstatic.com' ||
             url.origin === 'https://maxcdn.bootstrapcdn.com' ||
             url.origin === 'https://ajax.googleapis.com' ||
             url.origin === 'https://fonts.googleapis.com',
  			 
  	new workbox.strategies.CacheFirst({
    cacheName: 'cdn',
    plugins: [
      new workbox.cacheableResponse.Plugin({
        statuses: [0, 200],
      }),
      new workbox.expiration.Plugin({
        maxAgeSeconds: 60 * 60 * 24 * 365,
        maxEntries: 30,
      }),
    ],
  })
);



workbox.precaching.precacheAndRoute([]);

const networkFirstHandler = new workbox.strategies.NetworkFirst({
	cacheName: 'dynamic',
	plugins: [
		new workbox.expiration.Plugin({
			maxEntries: 10
		}),
		new workbox.cacheableResponse.Plugin({
			statuses: [200]
		})
	]
});

const FALLBACK_URL = workbox.precaching.getCacheKeyForURL('/offline.html');
const matcher = ({ event }) => event.request.mode === 'navigate';
const handler = args =>
	networkFirstHandler
		.handle(args)
		.then(response => response || caches.match(FALLBACK_URL))
		.catch(() => caches.match(FALLBACK_URL));

workbox.routing.registerRoute(matcher, handler);