importScripts(
	'https://storage.googleapis.com/workbox-cdn/releases/4.3.1/workbox-sw.js'
);


self.addEventListener('install', (event) => {
  self.skipWaiting();
  const urls = [
  'https://maxcdn.bootstrapcdn.com/bootswatch/3.3.5/united/bootstrap.min.css',
  'https://maxcdn.bootstrapcdn.com/bootswatch/3.3.5/cyborg/bootstrap.min.css',
  'https://maxcdn.bootstrapcdn.com/bootswatch/3.3.5/slate/bootstrap.min.css',
  'https://maxcdn.bootstrapcdn.com/bootswatch/3.3.5/cosmo/bootstrap.min.css',
  'https://maxcdn.bootstrapcdn.com/bootstrap/3.3.5/js/bootstrap.min.js',
  'https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js', 
  'https://fonts.googleapis.com/css?family=Ubuntu:400,700',
  'https://fonts.googleapis.com/css?family=Roboto:400,700',
  '/css/fontawesome-5.15.3/css/all.css',
  '/assets/theme/css/style.css',
  '/assets/mobirise/js/jquery.matchHeight-min.js',
  '/admin/css/main.css',
  '/admin/js/main.js',
  '/js/main.js',
  '/js/detalle.js',
  '/assets/images/logo.png',
  '/assets/images/logo-pdf.jpg',
  '/assets/images/logo-ticket.jpg',
  '/fotos/tu-marca.jpg',
  '/favicon.ico',
  '/logo.png',
  '/fotos/Alitas a la BBQ.jpg',
  '/fotos/Bebidas.jpg',
  '/fotos/Burritos.jpg',
  '/fotos/Coca-Cola.jpg',
  '/fotos/Corona.jpg',
  '/fotos/Fanta.jpg',
  '/fotos/Hamburguesa de pollo.jpg',
  '/fotos/Hamburguesa hawaiana.jpg',
  '/fotos/Hamburguesa sencilla.jpg',
  '/fotos/Hamburguesas.jpg',
  '/fotos/Hawaiana.jpg',
  '/fotos/Mexicana.jpg',
  '/fotos/Modelo Especial.jpg',
  '/fotos/Pepsi.jpg',
  '/fotos/Pizzas.jpg',
  '/fotos/Sincronizadas.jpg',
  '/fotos/sol.jpg',
  '/fotos/Tecate.jpg',
  '/fotos/Variedad.jpg',
  '/fotos/Varios.jpg',
  ];
  const cacheName  = workbox.core.cacheNames.runtime;
  event.waitUntil(caches.open('static' ).then((cache) => cache.addAll(urls)));
});

workbox.routing.registerRoute(
  ({url}) => url.origin === 'https://maxcdn.bootstrapcdn.com' ||
             url.origin === 'https://ajax.googleapis.com' ||
             url.origin === 'https://fonts.googleapis.com',
             

  new workbox.strategies.CacheOnly({cacheName: 'static'})
);

// js/css files
workbox.routing.registerRoute(
        /\.(?:js|css)$/,
        new workbox.strategies.CacheOnly({cacheName: 'static'})
    );

// images
    workbox.routing.registerRoute(
        // Cache image files.
        /\.(?:png|jpg|jpeg|svg|gif|ico)$/,
        // Use the cache if it's available.
        new workbox.strategies.CacheOnly({cacheName: 'static'})
    );

// Cache the underlying font files with a cache-first strategy for 1 year.
workbox.routing.registerRoute(
  ({url}) => url.origin === 'https://fonts.gstatic.com',
  new workbox.strategies.CacheFirst({
    cacheName: 'cdn',
    plugins: [
      new workbox.cacheableResponse.Plugin({
        statuses: [0, 200],
      }),
      new workbox.expiration.Plugin({
        maxAgeSeconds: 60 * 60 * 24 * 365,
        maxEntries: 30,
      }),
    ],
  })
);



workbox.precaching.precacheAndRoute([]);

const networkFirstHandler = new workbox.strategies.NetworkFirst({
	cacheName: 'dynamic',
	plugins: [
		new workbox.expiration.Plugin({
			maxEntries: 10
		}),
		new workbox.cacheableResponse.Plugin({
			statuses: [200]
		})
	]
});

const FALLBACK_URL = workbox.precaching.getCacheKeyForURL('/offline.html');
const matcher = ({ event }) => event.request.mode === 'navigate';
const handler = args =>
	networkFirstHandler
		.handle(args)
		.then(response => response || caches.match(FALLBACK_URL))
		.catch(() => caches.match(FALLBACK_URL));

workbox.routing.registerRoute(matcher, handler);